/////////////////////
// UIInGameClock.u
// In Game Clock - A simple in game clock that shows the system time
// Author: MachDelta
// Feb 16, 2016
/////////////////////
class UIInGameClock extends UIPanel config(InGameClock);

var private UIBGBox ClockBG;
var private UIText Clock;
var config bool b24HourClock;


simulated function UIInGameClock InitInGameClock()
{
	InitPanel();
	
	ClockBG = Spawn(class'UIBGBox', self);
	ClockBG.LibID = class'UIUtilities_Controls'.const.MC_X2Background;
	ClockBG.InitBG('InGameClockBackground', 0, 0, 110, 40);
	ClockBG.AnchorTopCenter();
	ClockBG.SetX(-55);
	ClockBG.SetAlpha(55.0);

	Clock = Spawn(class'UIText', self).InitText('InGameClockText');
	Clock.AnchorTopCenter();
	Clock.SetAlpha(80.0);
	UpdateClock();	
	SetTimer(10.0, true, 'UpdateClock', self);
	
	return self;
}

/*
simulated function DestroyClock()
{
	ClearTimer('UpdateClock');
}
*/

simulated function UpdateClock()
{
	Clock.SetHTMLText( class'UIUtilities_Text'.static.StyleText( GetClockTime(), eUITextStyle_Tooltip_Title ), CenterClock );
}


simulated function CenterClock()
{
	Clock.SetX(-55.0 + 0.5 * ClockBG.Width - 0.5 * Clock.Width);
	Clock.SetY((0.5 * ClockBG.Height) - (0.5 * Clock.Height));
}


simulated function string GetClockTime() // Custom Clock function, look at replacing with Firaxis' clock?
{
	local int Year, Month, DayOfWeek, Day, Hour, Min, Sec, MSec;
	local string strHour, strMin, Suffix, Pad;

	`XENGINE.GetSystemTime(Year, Month, DayOfWeek, Day, Hour, Min, Sec, MSec);

	if (!b24HourClock)
	{
		if (Hour > 12)
		{
			Hour = Hour - 12;
			Suffix = "PM";
		}
		else
		{
			Suffix = "AM";
			if (Hour == 0)
			{
				Hour = 12;
			}
		}
	}
	else
	{
		Suffix = "";
	}

	if (Min < 10)
	{
		Pad = "0";
	}
	else
	{
		Pad = "";
	}

	strHour = string(Hour);
	strMin = string(Min);

	return strHour$":"$Pad$strMin@Suffix;
}